/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.init.ModBlockEntities;

public class LootrChestBlockEntity
extends ChestBlockEntity
implements ILootBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected ResourceLocation savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId;
    protected boolean opened;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            LootrChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            LootrChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int p_155364_, int p_155365_) {
            LootrChestBlockEntity.this.m_142151_(level, pos, state, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.f_36096_).m_39261_();
            if (container instanceof SpecialChestInventory) {
                SpecialChestInventory chest = (SpecialChestInventory)container;
                return LootrChestBlockEntity.this.getTileId().equals(chest.getTileId());
            }
            return false;
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();

    protected LootrChestBlockEntity(BlockEntityType<?> p_155327_, BlockPos p_155328_, BlockState p_155329_) {
        super(p_155327_, p_155328_, p_155329_);
    }

    public LootrChestBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this(ModBlockEntities.SPECIAL_LOOT_CHEST, pWorldPosition, pBlockState);
    }

    public void m_59626_(ResourceLocation lootTableIn, long seedIn) {
        super.m_59626_(lootTableIn, seedIn);
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("specialLootChest_table"));
        }
        if (compound.m_128425_("specialLootChest_seed", 4)) {
            this.seed = compound.m_128454_("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.m_128425_("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("LootTable"));
            if (this.seed == 0L && compound.m_128425_("LootTableSeed", 4)) {
                this.seed = compound.m_128454_("LootTableSeed");
            }
        }
        if (compound.m_128403_("tileId")) {
            this.tileId = compound.m_128342_("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.m_128441_("LootrOpeners")) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.savedLootTable != null) {
            compound.m_128359_("specialLootChest_table", this.savedLootTable.toString());
            compound.m_128359_("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.m_128356_("specialLootChest_seed", this.seed);
            compound.m_128356_("LootTableSeed", this.seed);
        }
        compound.m_128362_("tileId", this.getTileId());
        ListTag list = new ListTag();
        for (UUID opener : this.openers) {
            list.add((Object)NbtUtils.m_129226_((UUID)opener));
        }
        compound.m_128365_("LootrOpeners", (Tag)list);
    }

    public static <T extends BlockEntity> void lootrLidAnimateTick(Level pLevel, BlockPos pPos, BlockState pState, T pBlockEntity) {
        ((LootrChestBlockEntity)pBlockEntity).chestLidController.m_155374_();
    }

    protected static void playSound(Level pLevel, BlockPos pPos, BlockState pState, SoundEvent pSound) {
        ChestType chesttype = (ChestType)pState.m_61143_((Property)ChestBlock.f_51479_);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = (double)pPos.m_123342_() + 0.5;
            double d2 = (double)pPos.m_123343_() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.m_51584_((BlockState)pState);
                d0 += (double)direction.m_122429_() * 0.5;
                d2 += (double)direction.m_122431_() * 0.5;
            }
            pLevel.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.chestLidController.m_155377_(pType > 0);
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_155350_() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public float m_6683_(float pPartialTicks) {
        return this.chestLidController.m_155375_(pPartialTicks);
    }

    @Override
    public void updatePacketViaState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
        }
    }

    public static int getOpenCount(BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockentity;
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (blockstate.m_155947_() && (blockentity = pLevel.m_7702_(pPos)) instanceof LootrChestBlockEntity) {
            return ((LootrChestBlockEntity)blockentity).openersCounter.m_155450_();
        }
        return 0;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag result = super.m_5995_();
        this.m_183515_(result);
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void m_59640_(@Nullable Player player) {
    }

    @Override
    public void unpackLootTable(Player player, Container inventory, ResourceLocation overrideTable, long seed) {
        if (this.f_58857_ != null && this.savedLootTable != null && this.f_58857_.m_142572_() != null) {
            LootTable loottable = this.f_58857_.m_142572_().m_129898_().m_79217_(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.f_79105_) {
                LootrAPI.LOG.error("Unable to fill loot chest in " + this.f_58857_.m_46472_() + " at " + this.f_58858_ + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.invalid_table", new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.savedLootTable);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_79123_(inventory, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = opened;
    }
}

